/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;

public final class Streams$ {
    public static final Streams$ MODULE$ = new Streams$();

    public InputStream resource(String name) {
        URL url = this.getClass().getClassLoader().getResource(name);
        if (url == null) {
            throw new FileNotFoundException(new java.lang.StringBuilder(10).append("resource: ").append(name).toString());
        }
        return url.openStream();
    }

    public InputStream fileIn(String name) {
        return Files.newInputStream(Paths.get(name, new String[0]), new OpenOption[0]);
    }

    public InputStream fileIn(File file) {
        return Files.newInputStream(file.toPath(), new OpenOption[0]);
    }

    public OutputStream fileOut(String name) {
        return Files.newOutputStream(Paths.get(name, new String[0]), new OpenOption[0]);
    }

    public OutputStream fileOut(File file) {
        return Files.newOutputStream(file.toPath(), new OpenOption[0]);
    }

    public byte[] byteArray(Function1<OutputStream, BoxedUnit> f) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        f.apply((Object)baos);
        return baos.toByteArray();
    }

    public byte[] byteArray(InputStream input) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int len = input.read(buf);
        while (len > 0) {
            baos.write(buf, 0, len);
            len = input.read(buf);
        }
        return baos.toByteArray();
    }

    public String string(Function1<Writer, BoxedUnit> f) {
        StringWriter w = new StringWriter();
        f.apply((Object)w);
        return w.toString();
    }

    public OutputStream gzip(OutputStream output) {
        return new GZIPOutputStream(output);
    }

    public InputStream gzip(InputStream input) {
        return new GZIPInputStream(input);
    }

    public BufferedReader reader(InputStream input) {
        return new BufferedReader(new InputStreamReader(input, "UTF-8"));
    }

    public Iterator<String> lines(InputStream input) {
        return this.lines(this.reader(input));
    }

    public Iterator<String> lines(Reader input) {
        BufferedReader bufferedReader;
        Reader reader = input;
        if (reader instanceof BufferedReader) {
            BufferedReader bufferedReader2;
            bufferedReader = bufferedReader2 = (BufferedReader)reader;
        } else if (reader != null) {
            Reader reader2 = reader;
            bufferedReader = new BufferedReader(reader2);
        } else {
            throw new MatchError((Object)reader);
        }
        BufferedReader reader3 = bufferedReader;
        return new Iterator<String>(reader3){
            private String value;
            private final BufferedReader reader$1;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<String> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<String> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<String> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<String>, Iterator<String>> partition(Function1<String, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, String, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<String, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<String, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<String> filter(Function1<String, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<String> filterNot(Function1<String, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<String> filterImpl(Function1<String, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<String> withFilter(Function1<String, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<String, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<String> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<String> distinctBy(Function1<String, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<String, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<String, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<String, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<String> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<String> takeWhile(Function1<String, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<String> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<String> dropWhile(Function1<String, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<String>, Iterator<String>> span(Function1<String, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<String> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<String> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<String, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<String, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<String>, Iterator<String>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<String> tapEach(Function1<String, U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<String> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<String>, Iterator<String>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<String, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<String, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<String, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<String, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<String> find(Function1<String, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, String, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<String, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, String, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<String, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, String, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<String, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, String, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<String, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<String> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<String> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<String> maxByOption(Function1<String, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<String> minByOption(Function1<String, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<String, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, String, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<String, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<String, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<String> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<String> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<String> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K$, V$> Map<K$, V$> toMap(.less.colon.less<String, Tuple2<K$, V$>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<String> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<String> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<String> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<String> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<String, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private String value() {
                return this.value;
            }

            private void value_$eq(String x$1) {
                this.value = x$1;
            }

            public boolean hasNext() {
                return this.value() != null;
            }

            /*
             * WARNING - void declaration
             */
            public String next() {
                void var1_1;
                String tmp = this.value();
                this.value_$eq(this.reader$1.readLine());
                return var1_1;
            }
            {
                this.reader$1 = reader$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.value = reader$1.readLine();
            }
        };
    }

    public <R extends Closeable, T> T scope(R res, Function1<R, T> f) {
        Object object;
        boolean thrown = false;
        try {
            try {
                object = f.apply(res);
            }
            catch (Throwable t) {
                thrown = true;
                throw t;
            }
        }
        catch (Throwable throwable) {
            if (thrown) {
                Exception$.MODULE$.ignoring((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{Throwable.class})).apply((Function0)(JFunction0.mcV.sp & Serializable)() -> res.close());
            } else {
                res.close();
            }
            throw throwable;
        }
        if (thrown) {
            Exception$.MODULE$.ignoring((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{Throwable.class})).apply((Function0)(JFunction0.mcV.sp & Serializable)() -> res.close());
        } else {
            res.close();
        }
        return (T)object;
    }

    private Streams$() {
    }
}

