/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.util;

import com.netflix.atlas.core.util.Hash$;
import com.netflix.atlas.core.util.LongHashSet$;
import com.netflix.atlas.core.util.PrimeFinder;
import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Builder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005m4A\u0001F\u000b\u0001A!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011\u0015y\u0003\u0001\"\u00011\u0011\u0019)\u0004\u0001)Q\u0005m!1\u0011\b\u0001Q!\n1BaA\u000f\u0001!B\u0013a\u0003\"B\u001e\u0001\t\u0013a\u0004\"B \u0001\t\u0013\u0001\u0005\"\u0002\"\u0001\t\u0013\u0019\u0005\"B$\u0001\t\u0013A\u0005\"B$\u0001\t\u0003\u0001\u0006\"\u0002*\u0001\t\u0003\u0019\u0006\"B-\u0001\t\u0003Q\u0006\"B.\u0001\t\u0003a\u0006\"B/\u0001\t\u0003qvaB6\u0016\u0003\u0003E\t\u0001\u001c\u0004\b)U\t\t\u0011#\u0001n\u0011\u0015y\u0013\u0003\"\u0001o\u0011\u001dy\u0017#%A\u0005\u0002A\u00141\u0002T8oO\"\u000b7\u000f[*fi*\u0011acF\u0001\u0005kRLGN\u0003\u0002\u00193\u0005!1m\u001c:f\u0015\tQ2$A\u0003bi2\f7O\u0003\u0002\u001d;\u00059a.\u001a;gY&D(\"\u0001\u0010\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004o_\u0012\u000bG/\u0019\t\u0003E%J!AK\u0012\u0003\t1{gnZ\u0001\tG\u0006\u0004\u0018mY5usB\u0011!%L\u0005\u0003]\r\u00121!\u00138u\u0003\u0019a\u0014N\\5u}Q\u0019\u0011g\r\u001b\u0011\u0005I\u0002Q\"A\u000b\t\u000b\u001d\u001a\u0001\u0019\u0001\u0015\t\u000f-\u001a\u0001\u0013!a\u0001Y\u0005!A-\u0019;b!\r\u0011s\u0007K\u0005\u0003q\r\u0012Q!\u0011:sCf\fA!^:fI\u000611-\u001e;pM\u001a\fQbY8naV$XmQ;u_\u001a4GC\u0001\u0017>\u0011\u0015qt\u00011\u0001-\u0003\u0005q\u0017\u0001\u00038fo\u0006\u0013(/Y=\u0015\u0005Y\n\u0005\"\u0002 \t\u0001\u0004a\u0013A\u0002:fg&TX\rF\u0001E!\t\u0011S)\u0003\u0002GG\t!QK\\5u\u0003\r\tG\r\u001a\u000b\u0004\u00132s\u0005C\u0001\u0012K\u0013\tY5EA\u0004C_>dW-\u00198\t\u000b5S\u0001\u0019\u0001\u001c\u0002\r\t,hMZ3s\u0011\u0015y%\u00021\u0001)\u0003\u00051HC\u0001#R\u0011\u0015y5\u00021\u0001)\u0003\u001d1wN]3bG\"$\"\u0001\u0012+\t\u000bUc\u0001\u0019\u0001,\u0002\u0003\u0019\u0004BAI,)\t&\u0011\u0001l\t\u0002\n\rVt7\r^5p]F\nAa]5{KV\tA&A\u0004u_\u0006\u0013(/Y=\u0016\u0003Y\na\u0001^8MSN$X#A0\u0011\u0007\u0001D\u0007F\u0004\u0002bM:\u0011!-Z\u0007\u0002G*\u0011AmH\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011J!aZ\u0012\u0002\u000fA\f7m[1hK&\u0011\u0011N\u001b\u0002\u0005\u0019&\u001cHO\u0003\u0002hG\u0005YAj\u001c8h\u0011\u0006\u001c\bnU3u!\t\u0011\u0014c\u0005\u0002\u0012CQ\tA.A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0002c*\u0012AF]\u0016\u0002gB\u0011A/_\u0007\u0002k*\u0011ao^\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001_\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002{k\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class LongHashSet {
    private final long noData;
    private long[] data;
    private int used;
    private int cutoff;

    public static int $lessinit$greater$default$2() {
        return LongHashSet$.MODULE$.$lessinit$greater$default$2();
    }

    private int computeCutoff(int n) {
        return package$.MODULE$.max(3, n / 2);
    }

    /*
     * WARNING - void declaration
     */
    private long[] newArray(int n) {
        void var2_2;
        long[] tmp = new long[PrimeFinder.nextPrime(n)];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.noData;
        }
        return var2_2;
    }

    private void resize() {
        long[] tmp = this.newArray(this.data.length * 2);
        for (int i = 0; i < this.data.length; ++i) {
            long v = this.data[i];
            Object object = v != this.noData ? BoxesRunTime.boxToBoolean((boolean)this.add(tmp, v)) : BoxedUnit.UNIT;
        }
        this.data = tmp;
        this.cutoff = this.computeCutoff(this.data.length);
    }

    private boolean add(long[] buffer, long v) {
        int pos = Hash$.MODULE$.absOrZero(Hash$.MODULE$.murmur3(v)) % buffer.length;
        long posV = buffer[pos];
        while (posV != this.noData && posV != v) {
            pos = (pos + 1) % buffer.length;
            posV = buffer[pos];
        }
        buffer[pos] = v;
        return posV == this.noData;
    }

    public void add(long v) {
        block1: {
            if (this.used >= this.cutoff) {
                this.resize();
            }
            if (!this.add(this.data, v)) break block1;
            ++this.used;
        }
    }

    public void foreach(Function1<Object, BoxedUnit> f) {
        for (int i = 0; i < this.data.length; ++i) {
            long v = this.data[i];
            if (v == this.noData) continue;
            f.apply$mcVJ$sp(v);
        }
    }

    public int size() {
        return this.used;
    }

    /*
     * WARNING - void declaration
     */
    public long[] toArray() {
        void var1_1;
        long[] tmp = new long[this.used];
        IntRef i = IntRef.create((int)0);
        this.foreach((Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)v -> {
            tmp$1[i$1.elem] = v;
            ++i$1.elem;
        });
        return var1_1;
    }

    public List<Object> toList() {
        Builder builder = List$.MODULE$.newBuilder();
        this.foreach((Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)v -> builder.$plus$eq((Object)BoxesRunTime.boxToLong((long)v)));
        return (List)builder.result();
    }

    public LongHashSet(long noData, int capacity) {
        this.noData = noData;
        this.data = this.newArray(capacity);
        this.used = 0;
        this.cutoff = this.computeCutoff(this.data.length);
    }
}

