/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.serde.serializers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.conduktor.serde.serializers.AvroConversionException;
import io.conduktor.serde.serializers.JsonGenericRecordReader$;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Base64;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.package$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import zio.CanFail$;
import zio.ZIO;
import zio.ZIO$;

public final class JsonToAvro$ {
    public static final JsonToAvro$ MODULE$ = new JsonToAvro$();
    private static final ObjectMapper om = new ObjectMapper();

    private ObjectMapper om() {
        return om;
    }

    private ZIO<Object, Throwable, Either<byte[], GenericRecord>> convertRecord(String jsonData, Schema schema, ZIO<Object, Throwable, Option<Object>> schemaId) {
        return ZIO$.MODULE$.effect((Function0 & Serializable)() -> MODULE$.om().readTree(jsonData)).flatMap((Function1 & Serializable)jsonNode -> schema.isUnion() ? schemaId.map((Function1 & Serializable)id -> package$.MODULE$.Left().apply((Object)MODULE$.genericJsonToBytes(jsonData, schema, (Option<Object>)id))) : ZIO$.MODULE$.effect((Function0 & Serializable)() -> JsonGenericRecordReader$.MODULE$.read((JsonNode)jsonNode, schema)).foldM((Function1 & Serializable)originalError -> ZIO$.MODULE$.effect((Function0 & Serializable)() -> (GenericRecord)MODULE$.genericJsonToAvro(jsonData, schema)).mapBoth((Function1 & Serializable)x$1 -> originalError, (Function1 & Serializable)value -> package$.MODULE$.Right().apply(value), CanFail$.MODULE$.canFail()), (Function1 & Serializable)value -> ZIO$.MODULE$.right((Function0 & Serializable)() -> value), CanFail$.MODULE$.canFail()));
    }

    public ZIO<Object, Throwable, Either<byte[], GenericRecord>> convert(String jsonData, Schema schema, ZIO<Object, Throwable, Option<Object>> schemaId) {
        Schema.Type type = schema.getType();
        boolean bl = Schema.Type.RECORD.equals(type) ? true : Schema.Type.UNION.equals(type);
        ZIO zIO = bl ? this.convertRecord(jsonData, schema, schemaId) : (Schema.Type.BYTES.equals(type) ? schemaId.map((Function1 & Serializable)id -> package$.MODULE$.Left().apply((Object)MODULE$.b64ToBytes(jsonData, (Option<Object>)id))) : (Schema.Type.ARRAY.equals(type) ? ZIO$.MODULE$.fail((Function0 & Serializable)() -> new AvroConversionException("JSON arrays at root are not supported")) : schemaId.map((Function1 & Serializable)id -> package$.MODULE$.Left().apply((Object)MODULE$.genericJsonToBytes(jsonData, schema, (Option<Object>)id)))));
        return zIO;
    }

    private <A> A genericJsonToAvro(String json, Schema schema) {
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, json);
        GenericDatumReader reader = new GenericDatumReader(schema);
        Object reuse = null;
        return (A)reader.read(reuse, (Decoder)decoder);
    }

    private <A> byte[] genericJsonToBytes(String json, Schema schema, Option<Object> schemaId) {
        A avro = this.genericJsonToAvro(json, schema);
        GenericDatumWriter w = new GenericDatumWriter(schema);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        schemaId.foreach((Function1)(JFunction1.mcVI.sp & Serializable)id -> {
            baos.write(0);
            baos.write(ByteBuffer.allocate(4).putInt(id).array());
        });
        BinaryEncoder e = EncoderFactory.get().binaryEncoder((OutputStream)baos, null);
        w.write(avro, (Encoder)e);
        e.flush();
        return baos.toByteArray();
    }

    private byte[] b64ToBytes(String json, Option<Object> schemaId) {
        String b64 = this.om().readTree(json).asText();
        byte[] decoded = Base64.getDecoder().decode(b64);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        schemaId.foreach((Function1)(JFunction1.mcVI.sp & Serializable)id -> {
            baos.write(0);
            baos.write(ByteBuffer.allocate(4).putInt(id).array());
        });
        baos.write(decoded);
        return baos.toByteArray();
    }

    private JsonToAvro$() {
    }
}

