/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import io.confluent.ksql.schema.ksql.JavaToSqlTypeConverter;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.utils.SchemaException;
import io.confluent.ksql.types.KsqlStruct;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

class JavaToSqlConverter
implements JavaToSqlTypeConverter {
    private static final BiMap<Class<?>, SqlBaseType> JAVA_TO_SQL = ImmutableBiMap.builder().put(Boolean.class, (Object)SqlBaseType.BOOLEAN).put(Integer.class, (Object)SqlBaseType.INTEGER).put(Long.class, (Object)SqlBaseType.BIGINT).put(Double.class, (Object)SqlBaseType.DOUBLE).put(String.class, (Object)SqlBaseType.STRING).put(BigDecimal.class, (Object)SqlBaseType.DECIMAL).put(List.class, (Object)SqlBaseType.ARRAY).put(Map.class, (Object)SqlBaseType.MAP).put(KsqlStruct.class, (Object)SqlBaseType.STRUCT).put(Date.class, (Object)SqlBaseType.DATE).put(Time.class, (Object)SqlBaseType.TIME).put(Timestamp.class, (Object)SqlBaseType.TIMESTAMP).put(ByteBuffer.class, (Object)SqlBaseType.BYTES).build();

    JavaToSqlConverter() {
    }

    @Override
    public SqlBaseType toSqlType(Class<?> javaType) {
        return JAVA_TO_SQL.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(javaType)).map(Map.Entry::getValue).findAny().orElseThrow(() -> new SchemaException("Unexpected java type: " + javaType));
    }
}

