/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.common.scala.config;

import cats.data.NonEmptyList;
import github4s.GHError;
import github4s.GHResponse;
import github4s.Github$;
import github4s.GithubConfig$;
import github4s.algebras.Repositories;
import github4s.domain.Content;
import io.conduktor.common.scala.config.ConfigError;
import io.conduktor.common.scala.config.ConfigurationCorrupted$;
import io.conduktor.common.scala.config.ConfigurationIsNotFile;
import io.conduktor.common.scala.config.EmptyConfiguration$;
import io.conduktor.common.scala.config.ExternalConfiguration;
import io.conduktor.common.scala.config.ExternalConfigurationService;
import io.conduktor.common.scala.config.ExternalConfigurationServiceLive$;
import io.conduktor.common.scala.config.Github;
import io.conduktor.common.scala.config.LocalFile;
import io.conduktor.common.scala.config.NoConfigurationFound;
import io.conduktor.common.scala.config.UnexpectedError;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.http4s.client.Client;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Left;
import scala.util.Right;
import zio.CanFail$;
import zio.Has;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.blocking.package;
import zio.interop.catz$;

@ScalaSignature(bytes="\u0006\u0005\u0005-q!B\u0006\r\u0011\u00039b!B\r\r\u0011\u0003Q\u0002\"\u0002\u0011\u0002\t\u0003\t\u0003b\u0002\u0012\u0002\u0005\u0004%\ta\t\u0005\u0007\u000f\u0006\u0001\u000b\u0011\u0002\u0013\u0007\tea!\u0001\u0013\u0005\t\u0013\u0016\u0011\t\u0011)A\u0005m!)\u0001%\u0002C\u0001\u0015\")Q*\u0002C!\u001d\")!/\u0002C\u0005g\")\u00110\u0002C\u0005u\u0006\u0001S\t\u001f;fe:\fGnQ8oM&<WO]1uS>t7+\u001a:wS\u000e,G*\u001b<f\u0015\tia\"\u0001\u0004d_:4\u0017n\u001a\u0006\u0003\u001fA\tQa]2bY\u0006T!!\u0005\n\u0002\r\r|W.\\8o\u0015\t\u0019B#A\u0005d_:$Wo\u001b;pe*\tQ#\u0001\u0002j_\u000e\u0001\u0001C\u0001\r\u0002\u001b\u0005a!\u0001I#yi\u0016\u0014h.\u00197D_:4\u0017nZ;sCRLwN\\*feZL7-\u001a'jm\u0016\u001c\"!A\u000e\u0011\u0005qqR\"A\u000f\u000b\u0003=I!aH\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq#A\u0003mCf,'/F\u0001%!\u0011)sFM\"\u000f\u0005\u0019bcBA\u0014+\u001b\u0005A#BA\u0015\u0017\u0003\u0019a$o\\8u}%\t1&A\u0002{S>L!!\f\u0018\u0002\u000fA\f7m[1hK*\t1&\u0003\u00021c\t9QK\u0015'bs\u0016\u0014(BA\u0017/!\r\u0019DGN\u0007\u0002]%\u0011QG\f\u0002\u0004\u0011\u0006\u001c\bcA\u001c?\u00016\t\u0001H\u0003\u0002:u\u000511\r\\5f]RT!a\u000f\u001f\u0002\r!$H\u000f\u001d\u001bt\u0015\u0005i\u0014aA8sO&\u0011q\b\u000f\u0002\u0007\u00072LWM\u001c;\u0011\u0005\u0015\n\u0015B\u0001\"2\u0005\u0011!\u0016m]6\u0011\u0007M\"D\t\u0005\u0002\u0019\u000b&\u0011a\t\u0004\u0002\u001d\u000bb$XM\u001d8bY\u000e{gNZ5hkJ\fG/[8o'\u0016\u0014h/[2f\u0003\u0019a\u0017-_3sAM\u0019Qa\u0007#\u0002\u0015!$H\u000f]\"mS\u0016tG\u000f\u0006\u0002L\u0019B\u0011\u0001$\u0002\u0005\u0006\u0013\u001e\u0001\rAN\u0001\u0010e\u00164'/Z:i\u0003N\u001cFO]5oOR\u0011q\n\u001d\t\u0006gA\u0013FlX\u0005\u0003#:\u00121AW%P!\t\u0019\u0016L\u0004\u0002U/:\u0011a%V\u0005\u0003-:\n\u0001B\u00197pG.LgnZ\u0005\u0003[aS!A\u0016\u0018\n\u0005i[&\u0001\u0003\"m_\u000e\\\u0017N\\4\u000b\u00055B\u0006C\u0001\r^\u0013\tqFBA\u0006D_:4\u0017nZ#se>\u0014\bc\u0001\u000faE&\u0011\u0011-\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\tq\u0019W\r[\u0005\u0003Iv\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\rg\u0013\t9GBA\u000bFqR,'O\\1m\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005%lgB\u00016l!\t9S$\u0003\u0002m;\u00051\u0001K]3eK\u001aL!A\\8\u0003\rM#(/\u001b8h\u0015\taW\u0004C\u0003r\u0011\u0001\u0007Q-A\u0007d_:4\u0017nZ;sCRLwN\\\u0001\fe\u00164'/Z:i\r&dW\r\u0006\u0002Pi\")Q/\u0003a\u0001m\u0006!a-\u001b7f!\tAr/\u0003\u0002y\u0019\tIAj\\2bY\u001aKG.Z\u0001\u0012e\u00164'/Z:i\rJ|WnR5uQV\u0014GcA>\u0002\bA!Q\u0005 /\u007f\u0013\ti\u0018G\u0001\u0002J\u001fB\u0019A\u0004Y@\u0011\u000bq\u0019\u0017\u0011\u00015\u0011\u0007a\t\u0019!C\u0002\u0002\u00061\u0011aaR5uQV\u0014\u0007bBA\u0005\u0015\u0001\u0007\u0011\u0011A\u0001\u0007O&$\b.\u001e2")
public final class ExternalConfigurationServiceLive
implements ExternalConfigurationService {
    private final Client<ZIO> httpClient;

    public static ZLayer<Has<Client<ZIO>>, Nothing$, Has<ExternalConfigurationService>> layer() {
        return ExternalConfigurationServiceLive$.MODULE$.layer();
    }

    @Override
    public ZIO<Has<package.Blocking.Service>, ConfigError, Option<Tuple2<ExternalConfiguration, String>>> refreshAsString(ExternalConfiguration configuration) {
        Object object;
        ExternalConfiguration externalConfiguration = configuration;
        if (externalConfiguration instanceof LocalFile) {
            LocalFile localFile = (LocalFile)externalConfiguration;
            object = this.refreshFile(localFile);
        } else if (externalConfiguration instanceof Github) {
            Github github = (Github)externalConfiguration;
            object = this.refreshFromGithub(github);
        } else {
            throw new MatchError((Object)externalConfiguration);
        }
        return object;
    }

    private ZIO<Has<package.Blocking.Service>, ConfigError, Option<Tuple2<ExternalConfiguration, String>>> refreshFile(LocalFile file) {
        return zio.blocking.package$.MODULE$.effectBlocking((Function0 & Serializable)() -> Files.readString(Path.of(file.path(), new String[0]))).refineOrDie((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IOException) {
                    IOException iOException = (IOException)A1;
                    object = new NoConfigurationFound(iOException);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof IOException;
                return bl;
            }
        }, (.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)content -> {
            String sha = DigestUtils.sha1Hex((String)content);
            return ZIO$.MODULE$.fail((Function0 & Serializable)() -> ConfigurationCorrupted$.MODULE$).unless((Function0)(JFunction0.mcZ.sp & Serializable)() -> file.knownSha().forall((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)ExternalConfigurationServiceLive.$anonfun$refreshFile$6(sha, x$17)))).map((Function1 & Serializable)x$18 -> {
                BoxedUnit boxedUnit = x$18;
                Some x$1 = new Some((Object)sha);
                String x$2 = file.copy$default$1();
                Option<String> x$3 = file.copy$default$3();
                Some some = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file.copy(x$2, (Option<String>)x$1, x$3)), content));
                return some;
            });
        });
    }

    private ZIO<Object, ConfigError, Option<Tuple2<Github, String>>> refreshFromGithub(Github github) {
        Repositories qual$1 = Github$.MODULE$.apply(this.httpClient, github.token(), catz$.MODULE$.concurrentInstance(), GithubConfig$.MODULE$.default()).repos();
        String x$1 = github.owner();
        String x$2 = github.repository();
        String x$3 = github.path();
        Option<String> x$4 = github.ref();
        Option x$5 = qual$1.getContents$default$5();
        Map x$6 = qual$1.getContents$default$6();
        return ((ZIO)qual$1.getContents(x$1, x$2, x$3, x$4, x$5, x$6)).mapError((Function1 & Serializable)cause -> new UnexpectedError((Throwable)cause), CanFail$.MODULE$.canFail()).flatMap(arg_0 -> ExternalConfigurationServiceLive.$anonfun$refreshFromGithub$2(github, arg_0));
    }

    public static final /* synthetic */ boolean $anonfun$refreshFile$6(String sha$1, String x$17) {
        String string = x$17;
        String string2 = sha$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Tuple2 $anonfun$refreshFromGithub$3(Content singleResult$1, Github github$1, String content$2) {
        Some x$7 = new Some((Object)singleResult$1.sha());
        String x$8 = github$1.copy$default$1();
        String x$9 = github$1.copy$default$2();
        String x$10 = github$1.copy$default$3();
        Option<String> x$11 = github$1.copy$default$4();
        Option<String> x$12 = github$1.copy$default$5();
        Option<String> x$13 = github$1.copy$default$7();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)github$1.copy(x$8, x$9, x$10, x$11, x$12, (Option<String>)x$7, x$13)), (Object)content$2);
    }

    public static final /* synthetic */ EmptyConfiguration$ $anonfun$refreshFromGithub$4() {
        return EmptyConfiguration$.MODULE$;
    }

    public static final /* synthetic */ ConfigurationIsNotFile $anonfun$refreshFromGithub$5(Github github$1) {
        return new ConfigurationIsNotFile(github$1.path());
    }

    public static final /* synthetic */ UnexpectedError $anonfun$refreshFromGithub$6(GHError err$1) {
        return new UnexpectedError((Throwable)err$1);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ ZIO $anonfun$refreshFromGithub$2(Github github$1, GHResponse x$20) {
        block11: {
            block10: {
                var4_2 = false;
                var5_3 = null;
                var6_4 = x$20.result();
                if (!(var6_4 instanceof Right)) break block10;
                var4_2 = true;
                var5_3 = (Right)var6_4;
                var7_5 = (NonEmptyList)var5_3.value();
                if (var7_5 == null) break block10;
                singleResult = (Content)var7_5.head();
                var9_7 = var7_5.tail();
                v0 = package$.MODULE$.Nil();
                var10_8 = var9_7;
                if (v0 != null ? v0.equals(var10_8) == false : var10_8 != null) break block10;
                var11_9 = false;
                var12_10 = null;
                var13_11 = singleResult.content();
                if (!(var13_11 instanceof Some)) ** GOTO lbl-1000
                var11_9 = true;
                var12_10 = (Some)var13_11;
                base64str = (String)var12_10.value();
                if (!github$1.knownSha().contains((Object)singleResult.sha())) {
                    content = new String(Base64.getDecoder().decode(StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(base64str)).mkString()), StandardCharsets.UTF_8);
                    var3_14 = ZIO$.MODULE$.some((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$refreshFromGithub$3(github4s.domain.Content io.conduktor.common.scala.config.Github java.lang.String ), ()Lscala/Tuple2;)((Content)singleResult, (Github)github$1, (String)content));
                } else if (var11_9) {
                    var3_14 = ZIO$.MODULE$.none();
                } else if (None$.MODULE$.equals(var13_11)) {
                    var3_14 = ZIO$.MODULE$.fail((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$refreshFromGithub$4(), ()Lio/conduktor/common/scala/config/EmptyConfiguration$;)());
                } else {
                    throw new MatchError((Object)var13_11);
                }
                var2_15 = var3_14;
                break block11;
            }
            if (var4_2) {
                var2_15 = ZIO$.MODULE$.fail((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$refreshFromGithub$5(io.conduktor.common.scala.config.Github ), ()Lio/conduktor/common/scala/config/ConfigurationIsNotFile;)((Github)github$1));
            } else if (var6_4 instanceof Left) {
                var16_16 = (Left)var6_4;
                err = (GHError)var16_16.value();
                var2_15 = ZIO$.MODULE$.fail((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$refreshFromGithub$6(github4s.GHError ), ()Lio/conduktor/common/scala/config/UnexpectedError;)((GHError)err));
            } else {
                throw new MatchError((Object)var6_4);
            }
        }
        return var2_15;
    }

    public ExternalConfigurationServiceLive(Client<ZIO> httpClient) {
        this.httpClient = httpClient;
    }
}

