/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4s;

import com.sksamuel.avro4s.AnnotationExtractors;
import com.sksamuel.avro4s.Avro4sConfigurationException;
import com.sksamuel.avro4s.Decoder;
import com.sksamuel.avro4s.DefaultFieldMapper$;
import com.sksamuel.avro4s.DefinitionEnvironment;
import com.sksamuel.avro4s.Encoder;
import com.sksamuel.avro4s.FieldMapper;
import com.sksamuel.avro4s.NameExtractor;
import com.sksamuel.avro4s.NameExtractor$;
import com.sksamuel.avro4s.SchemaFor;
import com.sksamuel.avro4s.SchemaFor$;
import com.sksamuel.avro4s.SchemaHelper$;
import com.sksamuel.avro4s.SchemaUpdate;
import com.sksamuel.avro4s.SchemaUpdate$NamespaceUpdate$;
import com.sksamuel.avro4s.SchemaUpdate$NoUpdate$;
import com.sksamuel.avro4s.TypeUnionDecoder;
import com.sksamuel.avro4s.TypeUnionEncoder;
import com.sksamuel.avro4s.TypeUnionEntry;
import java.io.Serializable;
import magnolia.SealedTrait;
import magnolia.Subtype;
import org.apache.avro.Schema;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class TypeUnions$ {
    public static final TypeUnions$ MODULE$ = new TypeUnions$();

    public <T> Encoder<T> encoder(SealedTrait<Encoder, T> ctx, DefinitionEnvironment<Encoder> env, SchemaUpdate update) {
        Seq subtypeEncoders = (Seq)this.enrichedSubtypes(ctx, update).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Subtype st = (Subtype)tuple2._1();
            SchemaUpdate u = (SchemaUpdate)tuple2._2();
            TypeUnionEntry.UnionEncoder.SubtypeEncoder subtypeEncoder = new TypeUnionEntry.UnionEncoder(st).apply(env, u);
            return subtypeEncoder;
        });
        SchemaFor<T> schemaFor = this.buildSchema(update, (Seq<Schema>)((Seq)subtypeEncoders.map((Function1 & Serializable)x$1 -> x$1.schema())));
        Map encoderBySubtype = ((IterableOnceOps)subtypeEncoders.map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.subtype()), e))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return new TypeUnionEncoder<T>(ctx, schemaFor, encoderBySubtype);
    }

    public <T> Decoder<T> decoder(SealedTrait<Decoder, T> ctx, DefinitionEnvironment<Decoder> env, SchemaUpdate update) {
        Seq subtypeDecoders = (Seq)this.enrichedSubtypes(ctx, update).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Subtype st = (Subtype)tuple2._1();
            SchemaUpdate u = (SchemaUpdate)tuple2._2();
            TypeUnionEntry.UnionDecoder.SubtypeDecoder subtypeDecoder = new TypeUnionEntry.UnionDecoder(st).apply(env, u);
            return subtypeDecoder;
        });
        SchemaFor<T> schemaFor = this.buildSchema(update, (Seq<Schema>)((Seq)subtypeDecoders.map((Function1 & Serializable)x$2 -> x$2.schema())));
        Map decoderByName = ((IterableOnceOps)subtypeDecoders.map((Function1 & Serializable)decoder -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)decoder.fullName()), decoder))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return new TypeUnionDecoder<T>(ctx, schemaFor, (Map<String, TypeUnionEntry.UnionDecoder.SubtypeDecoder>)decoderByName);
    }

    public <T> SchemaFor<T> schema(SealedTrait<SchemaFor, T> ctx, DefinitionEnvironment<SchemaFor> env, SchemaUpdate update) {
        Seq subtypeSchemas = (Seq)this.enrichedSubtypes(ctx, update).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Subtype st = (Subtype)tuple2._1();
            SchemaUpdate u = (SchemaUpdate)tuple2._2();
            TypeUnionEntry.UnionSchemaFor.SubtypeSchemaFor subtypeSchemaFor = new TypeUnionEntry.UnionSchemaFor(st).apply(env, u);
            return subtypeSchemaFor;
        });
        return this.buildSchema(update, (Seq<Schema>)((Seq)subtypeSchemas.map((Function1 & Serializable)x$3 -> x$3.schema())));
    }

    private <Typeclass, T> Seq<Tuple2<Subtype<Typeclass, T>, SchemaUpdate>> enrichedSubtypes(SealedTrait<Typeclass, T> ctx, SchemaUpdate update) {
        SchemaUpdate schemaUpdate;
        SchemaUpdate schemaUpdate2 = update;
        if (SchemaUpdate$NoUpdate$.MODULE$.equals(schemaUpdate2)) {
            Option<String> ns = new AnnotationExtractors((Seq<Object>)ctx.annotations()).namespace();
            schemaUpdate = (SchemaUpdate)ns.fold((Function0 & Serializable)() -> SchemaUpdate$NoUpdate$.MODULE$, (Function1)SchemaUpdate$NamespaceUpdate$.MODULE$);
        } else {
            schemaUpdate = update;
        }
        SchemaUpdate enrichedUpdate = schemaUpdate;
        Seq sortedSubtypes = (Seq)ctx.subtypes().sortWith((Function2 & Serializable)(l, r) -> BoxesRunTime.boxToBoolean((boolean)TypeUnions$.$anonfun$enrichedSubtypes$3(l, r)));
        return (Seq)sortedSubtypes.map((Function1 & Serializable)st -> new Tuple2(st, (Object)TypeUnions$.subtypeSchemaUpdate$1(st, enrichedUpdate, ctx)));
    }

    public <T> void validateNewSchema(SchemaFor<T> schemaFor) {
        Schema newSchema = schemaFor.schema();
        Schema.Type type = newSchema.getType();
        Schema.Type type2 = Schema.Type.UNION;
        if (type == null ? type2 != null : !type.equals(type2)) {
            throw new Avro4sConfigurationException(new StringBuilder(54).append("Schema type for record codecs must be UNION, received ").append(newSchema).toString());
        }
    }

    public <T> SchemaFor<T> buildSchema(SchemaUpdate update, Seq<Schema> schemas) {
        SchemaFor<Object> schemaFor;
        SchemaUpdate schemaUpdate = update;
        if (schemaUpdate instanceof SchemaUpdate.FullSchemaUpdate) {
            SchemaUpdate.FullSchemaUpdate fullSchemaUpdate = (SchemaUpdate.FullSchemaUpdate)schemaUpdate;
            SchemaFor<?> s = fullSchemaUpdate.schemaFor();
            schemaFor = s.forType();
        } else {
            schemaFor = SchemaFor$.MODULE$.apply(SchemaHelper$.MODULE$.createSafeUnion(schemas), DefaultFieldMapper$.MODULE$);
        }
        return schemaFor;
    }

    private static final SchemaUpdate subtypeSchemaUpdate$1(Subtype st, SchemaUpdate enrichedUpdate$1, SealedTrait ctx$1) {
        SchemaUpdate schemaUpdate;
        SchemaUpdate schemaUpdate2 = enrichedUpdate$1;
        if (schemaUpdate2 instanceof SchemaUpdate.FullSchemaUpdate) {
            SchemaUpdate.FullSchemaUpdate fullSchemaUpdate = (SchemaUpdate.FullSchemaUpdate)schemaUpdate2;
            SchemaFor<?> schemaFor = fullSchemaUpdate.schemaFor();
            Schema schema = schemaFor.schema();
            FieldMapper fieldMapper = schemaFor.fieldMapper();
            NameExtractor nameExtractor = NameExtractor$.MODULE$.apply(st.typeName(), (Seq<Object>)((Seq)st.annotations().$plus$plus((IterableOnce)ctx$1.annotations())));
            SchemaFor subtypeSchema = SchemaFor$.MODULE$.apply(SchemaHelper$.MODULE$.extractTraitSubschema(nameExtractor.fullName(), schema), fieldMapper);
            schemaUpdate = new SchemaUpdate.FullSchemaUpdate(subtypeSchema);
        } else {
            schemaUpdate = enrichedUpdate$1;
        }
        return schemaUpdate;
    }

    private static final float priority$1(Subtype st) {
        return BoxesRunTime.unboxToFloat((Object)new AnnotationExtractors((Seq<Object>)st.annotations()).sortPriority().getOrElse((Function0)(JFunction0.mcF.sp & Serializable)() -> 0.0f));
    }

    public static final /* synthetic */ boolean $anonfun$enrichedSubtypes$3(Subtype l, Subtype r) {
        return TypeUnions$.priority$1(l) > TypeUnions$.priority$1(r);
    }

    private TypeUnions$() {
    }
}

