/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4s;

import com.sksamuel.avro4s.AvroFormat;
import com.sksamuel.avro4s.AvroInputStreamBuilderWithSource;
import com.sksamuel.avro4s.Decoder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005A4AAC\u0006\u0001%!A!\u0004\u0001B\u0001B\u0003%1\u0004\u0003\u0005 \u0001\t\r\t\u0015a\u0003!\u0011\u0015q\u0003\u0001\"\u00010\u0011\u0015!\u0004\u0001\"\u00016\u0011\u0015!\u0004\u0001\"\u0001F\u0011\u0015!\u0004\u0001\"\u0001S\u0011\u0015!\u0004\u0001\"\u0001[\u0011\u0015!\u0004\u0001\"\u0001a\u0011\u0015!\u0004\u0001\"\u0001j\u0005Y\teO]8J]B,Ho\u0015;sK\u0006l')^5mI\u0016\u0014(B\u0001\u0007\u000e\u0003\u0019\tgO]85g*\u0011abD\u0001\tg.\u001c\u0018-\\;fY*\t\u0001#A\u0002d_6\u001c\u0001!\u0006\u0002\u0014KM\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0019|'/\\1u!\taR$D\u0001\f\u0013\tq2B\u0001\u0006BmJ|gi\u001c:nCR\f!\"\u001a<jI\u0016t7-\u001a\u00135!\ra\u0012eI\u0005\u0003E-\u0011q\u0001R3d_\u0012,'\u000f\u0005\u0002%K1\u0001A!\u0002\u0014\u0001\u0005\u00049#!\u0001+\u0012\u0005!Z\u0003CA\u000b*\u0013\tQcCA\u0004O_RD\u0017N\\4\u0011\u0005Ua\u0013BA\u0017\u0017\u0005\r\te._\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\u001aDCA\u00193!\ra\u0002a\t\u0005\u0006?\r\u0001\u001d\u0001\t\u0005\u00065\r\u0001\raG\u0001\u0005MJ|W\u000e\u0006\u00027sA\u0019AdN\u0012\n\u0005aZ!\u0001I!we>Le\u000e];u'R\u0014X-Y7Ck&dG-\u001a:XSRD7k\\;sG\u0016DQA\u000f\u0003A\u0002m\nA\u0001]1uQB\u0011AhQ\u0007\u0002{)\u0011ahP\u0001\u0005M&dWM\u0003\u0002A\u0003\u0006\u0019a.[8\u000b\u0003\t\u000bAA[1wC&\u0011A)\u0010\u0002\u0005!\u0006$\b\u000e\u0006\u00027\r\")!(\u0002a\u0001\u000fB\u0011\u0001j\u0014\b\u0003\u00136\u0003\"A\u0013\f\u000e\u0003-S!\u0001T\t\u0002\rq\u0012xn\u001c;?\u0013\tqe#\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u0013aa\u0015;sS:<'B\u0001(\u0017)\t14\u000bC\u0003?\r\u0001\u0007A\u000b\u0005\u0002V16\taK\u0003\u0002X\u0003\u0006\u0011\u0011n\\\u0005\u00033Z\u0013AAR5mKR\u0011ag\u0017\u0005\u00069\u001e\u0001\r!X\u0001\u0003S:\u0004\"!\u00160\n\u0005}3&aC%oaV$8\u000b\u001e:fC6$\"AN1\t\u000b\tD\u0001\u0019A2\u0002\u000b\tLH/Z:\u0011\u0007U!g-\u0003\u0002f-\t)\u0011I\u001d:bsB\u0011QcZ\u0005\u0003QZ\u0011AAQ=uKR\u0011aG\u001b\u0005\u0006W&\u0001\r\u0001\\\u0001\u0007EV4g-\u001a:\u0011\u00055tW\"A \n\u0005=|$A\u0003\"zi\u0016\u0014UO\u001a4fe\u0002")
public class AvroInputStreamBuilder<T> {
    private final AvroFormat format;
    private final Decoder<T> evidence$4;

    public AvroInputStreamBuilderWithSource<T> from(Path path) {
        return this.from(Files.newInputStream(path, new OpenOption[0]));
    }

    public AvroInputStreamBuilderWithSource<T> from(String path) {
        return this.from(Paths.get(path, new String[0]));
    }

    public AvroInputStreamBuilderWithSource<T> from(File file) {
        return this.from(file.toPath());
    }

    public AvroInputStreamBuilderWithSource<T> from(InputStream in) {
        return new AvroInputStreamBuilderWithSource<T>(this.format, in, this.evidence$4);
    }

    public AvroInputStreamBuilderWithSource<T> from(byte[] bytes) {
        return this.from(new ByteArrayInputStream(bytes));
    }

    public AvroInputStreamBuilderWithSource<T> from(ByteBuffer buffer) {
        return this.from(new ByteArrayInputStream(buffer.array()));
    }

    public AvroInputStreamBuilder(AvroFormat format, Decoder<T> evidence$4) {
        this.format = format;
        this.evidence$4 = evidence$4;
    }
}

