/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics;

import java.io.IOException;
import javax.annotation.Nonnull;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class AnalyticsRequestInterceptor
implements Interceptor {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String USER_AGENT_HEADER = "User-Agent";
    @Nonnull
    private final String writeKey;
    @Nonnull
    private final String userAgent;

    AnalyticsRequestInterceptor(@Nonnull String writeKey, @Nonnull String userAgent) {
        this.writeKey = writeKey;
        this.userAgent = userAgent;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request newRequest = request.newBuilder().addHeader(AUTHORIZATION_HEADER, Credentials.basic((String)this.writeKey, (String)"")).addHeader(USER_AGENT_HEADER, this.userAgent).build();
        return chain.proceed(newRequest);
    }
}

