/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.properties;

import io.confluent.ksql.config.ConfigItem;
import io.confluent.ksql.config.ConfigResolver;
import io.confluent.ksql.config.KsqlConfigResolver;
import io.confluent.ksql.config.PropertyParser;
import io.confluent.ksql.config.PropertyValidator;
import io.confluent.ksql.properties.LocalPropertyValidator;
import java.util.Objects;

public class LocalPropertyParser
implements PropertyParser {
    private final ConfigResolver resolver;
    private final PropertyValidator validator;

    public LocalPropertyParser() {
        this(new KsqlConfigResolver(), new LocalPropertyValidator());
    }

    LocalPropertyParser(ConfigResolver resolver, PropertyValidator validator) {
        this.resolver = Objects.requireNonNull(resolver, "resolver");
        this.validator = Objects.requireNonNull(validator, "validator");
    }

    @Override
    public Object parse(String property, Object value) {
        if (property.equalsIgnoreCase("ksql.run.script.statements")) {
            this.validator.validate(property, value);
            return value;
        }
        ConfigItem configItem = this.resolver.resolve(property, true).orElseThrow(() -> new IllegalArgumentException(String.format("Not recognizable as ksql, streams, consumer, or producer property: '%s'", property)));
        Object parsedValue = configItem.parseValue(value);
        this.validator.validate(configItem.getPropertyName(), parsedValue);
        return parsedValue;
    }
}

