/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AggregateFunctionInitArguments {
    public static final AggregateFunctionInitArguments EMPTY_ARGS = new AggregateFunctionInitArguments();
    private final int udafIndex;
    private final List<Object> initArgs;
    private final ImmutableMap<String, ?> config;

    public AggregateFunctionInitArguments(int index, Object ... initArgs) {
        this(index, (Map<String, ?>)ImmutableMap.of(), Arrays.asList(initArgs));
    }

    public AggregateFunctionInitArguments(int index, Map<String, ?> config, Object ... initArgs) {
        this(index, config, Arrays.asList(initArgs));
    }

    public AggregateFunctionInitArguments(int index, Map<String, ?> config, List<Object> initArgs) {
        this.udafIndex = index;
        this.config = ImmutableMap.copyOf(Objects.requireNonNull(config, "config"));
        this.initArgs = new ArrayList<Object>((Collection)Objects.requireNonNull(initArgs, "initArgs"));
        if (index < 0) {
            throw new IllegalArgumentException("index is negative: " + index);
        }
    }

    private AggregateFunctionInitArguments() {
        this.udafIndex = 0;
        this.config = ImmutableMap.of();
        this.initArgs = ImmutableList.of();
    }

    public int udafIndex() {
        return this.udafIndex;
    }

    public Object arg(int i) {
        return this.initArgs.get(i);
    }

    public List<Object> args() {
        return Collections.unmodifiableList(this.initArgs);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="config is ImmutableMap")
    public Map<String, ?> config() {
        return this.config;
    }
}

