/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.analytics.tracking;

import io.conduktor.analytics.tracking.AnalyticsObject;
import io.conduktor.analytics.tracking.AnalyticsTracker;
import io.conduktor.analytics.tracking.ExtensionsKt;
import io.conduktor.analytics.tracking.ObjectAction;
import io.conduktor.developers.Activity;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/conduktor/analytics/tracking/ConsoleTracker;", "Lio/conduktor/analytics/tracking/AnalyticsTracker;", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "action", "", "objectAction", "Lio/conduktor/analytics/tracking/ObjectAction;", "props", "", "", "", "error", "ex", "", "time", "activity", "Lio/conduktor/developers/Activity;", "visit", "path", "Lio/conduktor/analytics/tracking/AnalyticsObject;", "desktop"})
public final class ConsoleTracker
extends AnalyticsTracker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void visit(@NotNull AnalyticsObject path, @NotNull Map<String, ? extends Object> props) {
        this.logger.debug("visit event: {} - props: {}", (Object)("cdk.desktop." + path.name() + ".Viewed"), ExtensionsKt.flatten(props));
    }

    @Override
    public void error(@NotNull Throwable ex) {
        this.logger.debug("error: " + ex.getMessage() + " (kafka: " + this.getKafkaVersions() + ")");
    }

    @Override
    public void action(@NotNull ObjectAction objectAction, @NotNull Map<String, ? extends Object> props) {
        this.logger.debug("action event: {} - props: {}", (Object)("cdk.desktop." + objectAction), ExtensionsKt.flatten(props));
    }

    @Override
    public void time(@NotNull Activity activity) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)activity.getDesc()), TuplesKt.to((Object)"time", (Object)String.valueOf(activity.getElapsedMillis())), TuplesKt.to((Object)"err", (Object)activity.getError())};
        this.logger.debug("time: " + MapsKt.mapOf((Pair[])pairArray));
    }
}

