/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.jumpstart.helper;

import io.conduktor.jumpstart.helper.SafeFileOps;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.LinkOption;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.CanFail$;
import zio.Has;
import zio.ZIO;
import zio.ZIO$;
import zio.blocking.package;
import zio.nio.file.Files$;
import zio.nio.file.Path;
import zio.nio.file.Path$;

public final class SafeFileOps$ {
    public static final SafeFileOps$ MODULE$ = new SafeFileOps$();
    private static final Set<Path> safeFolders = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{Path$.MODULE$.apply("conduktor", (Seq)Nil$.MODULE$), Path$.MODULE$.apply("jumpstart", (Seq)Nil$.MODULE$)}));

    private Set<Path> safeFolders() {
        return safeFolders;
    }

    public ZIO<Has<package.Blocking.Service>, SafeFileOps.NotFile, BoxedUnit> createFile(Path file) {
        return ZIO.IfM$.MODULE$.apply$extension(ZIO$.MODULE$.ifM(Files$.MODULE$.isDirectory(file, (Seq)Nil$.MODULE$)), (Function0 & Serializable)() -> ZIO$.MODULE$.fail((Function0 & Serializable)() -> new SafeFileOps.NotFile(file)), (Function0 & Serializable)() -> Files$.MODULE$.createFile(file, (Seq)Nil$.MODULE$).catchSome((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends IOException, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof FileAlreadyExistsException ? ZIO$.MODULE$.unit() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(IOException x1) {
                IOException iOException = x1;
                boolean bl = iOException instanceof FileAlreadyExistsException;
                return bl;
            }
        }, CanFail$.MODULE$.canFail()).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail()));
    }

    public ZIO<Has<package.Blocking.Service>, SafeFileOps.NotDirectory, BoxedUnit> createDirectories(Path dir) {
        return Files$.MODULE$.createDirectories(dir, (Seq)Nil$.MODULE$).catchAll((Function1 & Serializable)x0$1 -> {
            IOException iOException = x0$1;
            ZIO zIO = iOException instanceof FileAlreadyExistsException ? ZIO$.MODULE$.fail((Function0 & Serializable)() -> new SafeFileOps.NotDirectory(dir)) : ZIO$.MODULE$.die((Function0 & Serializable)() -> iOException);
            return zIO;
        }, CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, SafeFileOps.FileOperationError, BoxedUnit> deleteRecursively(Path dir) {
        return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.fail((Function0 & Serializable)() -> new SafeFileOps.UnsafePath(dir)).unlessM(this.isSafe(dir)).flatMap((Function1 & Serializable)x$4 -> {
            BoxedUnit boxedUnit = x$4;
            ZIO zIO = Files$.MODULE$.newDirectoryStream(dir, Files$.MODULE$.newDirectoryStream$default$2()).whenM(Files$.MODULE$.isDirectory(dir, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS}))).foreach((Function1 & Serializable)dir -> MODULE$.deleteRecursively((Path)dir)).flatMap((Function1 & Serializable)x$3 -> {
                BoxedUnit boxedUnit = x$3;
                ZIO zIO = ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(ZIO$.MODULE$.ZioRefineToOrDieOps(Files$.MODULE$.deleteIfExists(dir)), ClassTag$.MODULE$.apply(FileSystemException.class), CanFail$.MODULE$.canFail()).mapError((Function1 & Serializable)x$1 -> new SafeFileOps.CantDeleteDirectory(dir), CanFail$.MODULE$.canFail()).map((Function1 & Serializable)x$2 -> {
                    SafeFileOps$.$anonfun$deleteRecursively$6(BoxesRunTime.unboxToBoolean((Object)x$2));
                    return BoxedUnit.UNIT;
                });
                return zIO;
            });
            return zIO;
        }).whenM(Files$.MODULE$.exists(dir, (Seq)Nil$.MODULE$))), ClassTag$.MODULE$.apply(SafeFileOps.FileOperationError.class), CanFail$.MODULE$.canFail());
    }

    public ZIO<Has<package.Blocking.Service>, Nothing$, Object> isSafe(Path path) {
        return path.toRealPath((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS})).orDie((.less.colon.less)$less$colon$less$.MODULE$.refl(), CanFail$.MODULE$.canFail()).map((Function1 & Serializable)realPath -> BoxesRunTime.boxToBoolean((boolean)SafeFileOps$.$anonfun$isSafe$1(realPath)));
    }

    public static final /* synthetic */ void $anonfun$deleteRecursively$6(boolean x$2) {
        boolean bl = x$2;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$isSafe$1(Path realPath) {
        return realPath.elements().exists(MODULE$.safeFolders());
    }

    private SafeFileOps$() {
    }
}

