/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.jumpstart;

import cats.Applicative;
import cats.UnorderedFoldable$;
import cats.free.Free;
import cats.free.Free$;
import cats.syntax.package;
import io.conduktor.jumpstart.KafkaProcess;
import io.conduktor.jumpstart.KafkaProcess$;
import io.conduktor.jumpstart.SchemaRegistryProcess;
import io.conduktor.jumpstart.SchemaRegistryProcess$;
import io.conduktor.jumpstart.ZookeeperProcess;
import io.conduktor.jumpstart.ZookeeperProcess$;
import io.conduktor.jumpstart.domain.Component;
import io.conduktor.jumpstart.domain.JumpStartError;
import io.conduktor.jumpstart.domain.JumpStartError$NodeExists$;
import io.conduktor.jumpstart.domain.JumpstartRunning;
import io.conduktor.jumpstart.domain.Kafka$;
import io.conduktor.jumpstart.domain.KafkaRunning$;
import io.conduktor.jumpstart.domain.KafkaStarting$;
import io.conduktor.jumpstart.domain.KafkaStopped$;
import io.conduktor.jumpstart.domain.KafkaStopping$;
import io.conduktor.jumpstart.domain.ProcessEvent;
import io.conduktor.jumpstart.domain.RegistryBinDir;
import io.conduktor.jumpstart.domain.RegistryRunning$;
import io.conduktor.jumpstart.domain.RegistryStarting$;
import io.conduktor.jumpstart.domain.RegistryStopped$;
import io.conduktor.jumpstart.domain.RegistryStopping$;
import io.conduktor.jumpstart.domain.ScriptConfig;
import io.conduktor.jumpstart.domain.ShutdownSignal;
import io.conduktor.jumpstart.domain.ZookeeperRunning$;
import io.conduktor.jumpstart.domain.ZookeeperStarting$;
import io.conduktor.jumpstart.domain.ZookeeperStopped$;
import io.conduktor.jumpstart.domain.ZookeeperStopping$;
import io.conduktor.jumpstart.helper.JumpstartFiber;
import io.conduktor.jumpstart.helper.ProcessUtils$;
import io.conduktor.jumpstart.package;
import io.conduktor.jumpstart.package$Step$;
import io.conduktor.primitives.types.Port;
import izumi.reflect.Tag;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import zio.Accessible$;
import zio.CanFail$;
import zio.Has;
import zio.IO$;
import zio.Schedule$;
import zio.UIO$;
import zio.ZIO;
import zio.ZManaged;
import zio.ZManaged$;
import zio.clock.package$;
import zio.duration.package;
import zio.logging.Logger;
import zio.logging.Logging$;
import zio.nio.file.Path;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class Jumpstart$ {
    public static final Jumpstart$ MODULE$ = new Jumpstart$();

    public ZStream<Has<Logger<String>>, JumpStartError, ProcessEvent> launch(ShutdownSignal shutdownSignal) {
        return ZStream$.MODULE$.service(Tag$.MODULE$.apply(ScriptConfig.class, LightTypeTag$.MODULE$.parse(-1595098146, "\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001*io.conduktor.jumpstart.domain.ScriptConfig\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0003\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001", 21))).flatMap((Function1 & Serializable)x$1 -> MODULE$.run((ScriptConfig)x$1, shutdownSignal));
    }

    private ZStream<Has<Logger<String>>, JumpStartError, ProcessEvent> run(ScriptConfig config, ShutdownSignal shutdownSignal) {
        return package$Step$.MODULE$.runStream(shutdownSignal, (Free<package.Step.ProcessStep, JumpstartRunning>)this.launchZookeeper(config).flatMap((Function1 & Serializable)zkConfig -> MODULE$.launchKafka(config, (ZookeeperProcess.ZookeeperConfig)zkConfig, shutdownSignal).flatMap((Function1 & Serializable)kafkaConfig -> ((Free)package.traverse$.MODULE$.toTraverseOps(config.registryBinDir(), UnorderedFoldable$.MODULE$.catsTraverseForOption()).traverse((Function1 & Serializable)binDir -> MODULE$.launchRegistry(config, (RegistryBinDir)binDir, (KafkaProcess.KafkaConfig)kafkaConfig), (Applicative)Free$.MODULE$.catsFreeMonadForFree())).map((Function1 & Serializable)registryConfig -> new JumpstartRunning(kafkaConfig.port(), zkConfig.port(), kafkaConfig.logs(), zkConfig.logs(), (Option<Port>)registryConfig.map((Function1 & Serializable)x$2 -> x$2.port()), (Option<Path>)registryConfig.map((Function1 & Serializable)x$3 -> x$3.logs()))))));
    }

    private Free<package.Step.ProcessStep, ZookeeperProcess.ZookeeperConfig> launchZookeeper(ScriptConfig config) {
        return package$Step$.MODULE$.step((Function1<Path, ProcessEvent>)ZookeeperStarting$.MODULE$, (Function1<Object, ProcessEvent>)ZookeeperRunning$.MODULE$, ZookeeperStopping$.MODULE$, ZookeeperStopped$.MODULE$, (ZManaged<Has<Logger<String>>, JumpStartError, Path>)Jumpstart$.managedPrepareLogFile$1(config), (Function1 & Serializable)x$6 -> Jumpstart$.managedProcess$1(x$6));
    }

    private Free<package.Step.ProcessStep, KafkaProcess.KafkaConfig> launchKafka(ScriptConfig config, ZookeeperProcess.ZookeeperConfig zkConfig, ShutdownSignal shutdownSignal) {
        long retryDelayMs = KafkaProcess$.MODULE$.ZookeeperTimeoutMs() + ZookeeperProcess$.MODULE$.DefaultTickTimeMs();
        return package$Step$.MODULE$.step((Function1<Path, ProcessEvent>)KafkaStarting$.MODULE$, (Function1<Object, ProcessEvent>)KafkaRunning$.MODULE$, KafkaStopping$.MODULE$, KafkaStopped$.MODULE$, (ZManaged<Has<Logger<String>>, JumpStartError, Path>)Jumpstart$.prepareLogFile$1(config), (Function1 & Serializable)x$13 -> Jumpstart$.managedProcess$2(x$13, zkConfig, shutdownSignal, retryDelayMs));
    }

    private Free<package.Step.ProcessStep, SchemaRegistryProcess.SchemaRegistryConfig> launchRegistry(ScriptConfig config, RegistryBinDir registryDir, KafkaProcess.KafkaConfig kafkaConfig) {
        return package$Step$.MODULE$.step((Function1<Path, ProcessEvent>)RegistryStarting$.MODULE$, (Function1<Object, ProcessEvent>)RegistryRunning$.MODULE$, RegistryStopping$.MODULE$, RegistryStopped$.MODULE$, (ZManaged<Has<Logger<String>>, JumpStartError, Path>)Jumpstart$.prepareLogFile$2(config), (Function1 & Serializable)x$16 -> Jumpstart$.managedProcess$3(x$16, registryDir, kafkaConfig));
    }

    private static final ZManaged managedPrepareLogFile$1(ScriptConfig config$2) {
        return ZManaged$.MODULE$.fromEffect(ProcessUtils$.MODULE$.prepareLogFile(config$2.workingDirectory(), "zookeeper.log"));
    }

    private static final ZManaged managedProcess$1(Path processEnv) {
        return ZookeeperProcess$.MODULE$.apply((Function1 & Serializable)x$4 -> x$4.launchAndWaitRunning(processEnv).interruptible(), (Tag<ZookeeperProcess>)Tag$.MODULE$.apply(ZookeeperProcess.class, LightTypeTag$.MODULE$.parse(-1025908056, "\u0004\u0000\u0001'io.conduktor.jumpstart.ZookeeperProcess\u0001\u0001", "\u0000\u0000\u0000", 21)), Accessible$.MODULE$.anyIsAny()).toManaged((Function1 & Serializable)x$5 -> ((JumpstartFiber)x$5._1()).stopProcess());
    }

    private static final ZManaged prepareLogFile$1(ScriptConfig config$3) {
        return ZManaged$.MODULE$.fromEffect(ProcessUtils$.MODULE$.prepareLogFile(config$3.workingDirectory(), "kafka.log"));
    }

    public static final /* synthetic */ boolean $anonfun$launchKafka$8(boolean shouldRetry$1, BoxedUnit x$8) {
        BoxedUnit boxedUnit = x$8;
        boolean bl = shouldRetry$1;
        return bl;
    }

    public static final /* synthetic */ ZIO $anonfun$launchKafka$5(boolean shouldRetry) {
        return Logging$.MODULE$.warn((Function0 & Serializable)() -> "Kafka lock is already held. The Kafka cluster is probably already running or is going to be stopped. Retrying...").when((Function0)(JFunction0.mcZ.sp & Serializable)() -> shouldRetry).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Jumpstart$.$anonfun$launchKafka$8(shouldRetry, x$8)));
    }

    public static final /* synthetic */ boolean $anonfun$launchKafka$18(boolean shouldRetry$2, BoxedUnit x$11) {
        BoxedUnit boxedUnit = x$11;
        boolean bl = shouldRetry$2;
        return bl;
    }

    public static final /* synthetic */ ZIO $anonfun$launchKafka$15(boolean shouldRetry) {
        return Logging$.MODULE$.warn((Function0 & Serializable)() -> "Kafka node is already registered on Zookeeper. The cluster have probably be suddenly interrupted previously. Retrying...").when((Function0)(JFunction0.mcZ.sp & Serializable)() -> shouldRetry).map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)Jumpstart$.$anonfun$launchKafka$18(shouldRetry, x$11)));
    }

    private static final ZIO startProcess$1(Path logPath, ZookeeperProcess.ZookeeperConfig zkConfig$2, ShutdownSignal shutdownSignal$3, long retryDelayMs$1) {
        return package$.MODULE$.instant().flatMap((Function1 & Serializable)startTime -> KafkaProcess$.MODULE$.apply((Function1 & Serializable)x$7 -> x$7.launchAndWaitRunning(logPath, zkConfig$2), (Tag<KafkaProcess>)Tag$.MODULE$.apply(KafkaProcess.class, LightTypeTag$.MODULE$.parse(-1899950062, "\u0004\u0000\u0001#io.conduktor.jumpstart.KafkaProcess\u0001\u0001", "\u0000\u0000\u0000", 21)), Accessible$.MODULE$.anyIsAny()).retry(Schedule$.MODULE$.delayed(Schedule$.MODULE$.recurs(4).as((Function0 & Serializable)() -> zio.duration.package$.MODULE$.durationInt(10).seconds())).whileInputM((Function1 & Serializable)x0$1 -> {
            JumpStartError.LockFileAlreadyHeld lockFileAlreadyHeld;
            Component component;
            JumpStartError jumpStartError = x0$1;
            ZIO zIO = jumpStartError instanceof JumpStartError.LockFileAlreadyHeld && Kafka$.MODULE$.equals(component = (lockFileAlreadyHeld = (JumpStartError.LockFileAlreadyHeld)jumpStartError).component()) ? shutdownSignal$3.isDone().unary_$bang((.less.colon.less)$less$colon$less$.MODULE$.refl()).flatMap((Function1 & Serializable)shouldRetry -> Jumpstart$.$anonfun$launchKafka$5(BoxesRunTime.unboxToBoolean((Object)shouldRetry))) : IO$.MODULE$.succeed((Function0)(JFunction0.mcZ.sp & Serializable)() -> false);
            return zIO;
        }), CanFail$.MODULE$.canFail()).retry(Schedule$.MODULE$.once().addDelayM((Function1 & Serializable)x$9 -> package$.MODULE$.instant().map((Function1 & Serializable)x$10 -> package.Duration$.MODULE$.fromInterval(x$10, startTime.plusMillis(retryDelayMs$1)))).$plus$plus(Schedule$.MODULE$.once()).whileInputM((Function1 & Serializable)err -> UIO$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            JumpStartError jumpStartError = err;
            JumpStartError$NodeExists$ jumpStartError$NodeExists$ = JumpStartError$NodeExists$.MODULE$;
            return !(jumpStartError != null ? !jumpStartError.equals(jumpStartError$NodeExists$) : jumpStartError$NodeExists$ != null);
        }).$amp$amp((Function0 & Serializable)() -> shutdownSignal$3.isDone().unary_$bang((.less.colon.less)$less$colon$less$.MODULE$.refl()), (.less.colon.less)$less$colon$less$.MODULE$.refl()).flatMap((Function1 & Serializable)shouldRetry -> Jumpstart$.$anonfun$launchKafka$15(BoxesRunTime.unboxToBoolean((Object)shouldRetry)))), CanFail$.MODULE$.canFail()));
    }

    private static final ZManaged managedProcess$2(Path logPath, ZookeeperProcess.ZookeeperConfig zkConfig$2, ShutdownSignal shutdownSignal$3, long retryDelayMs$1) {
        return Jumpstart$.startProcess$1(logPath, zkConfig$2, shutdownSignal$3, retryDelayMs$1).interruptible().toManaged((Function1 & Serializable)x$12 -> ((JumpstartFiber)x$12._1()).stopProcess());
    }

    private static final ZManaged prepareLogFile$2(ScriptConfig config$4) {
        return ZManaged$.MODULE$.fromEffect(ProcessUtils$.MODULE$.prepareLogFile(config$4.workingDirectory(), "schema-registry.log"));
    }

    private static final ZManaged managedProcess$3(Path processEnv, RegistryBinDir registryDir$1, KafkaProcess.KafkaConfig kafkaConfig$2) {
        return SchemaRegistryProcess$.MODULE$.apply((Function1 & Serializable)x$14 -> x$14.launchAndWaitRunning(processEnv, registryDir$1, kafkaConfig$2).interruptible(), (Tag<SchemaRegistryProcess>)Tag$.MODULE$.apply(SchemaRegistryProcess.class, LightTypeTag$.MODULE$.parse(-1383030873, "\u0004\u0000\u0001,io.conduktor.jumpstart.SchemaRegistryProcess\u0001\u0001", "\u0000\u0000\u0000", 21)), Accessible$.MODULE$.anyIsAny()).toManaged((Function1 & Serializable)x$15 -> ((JumpstartFiber)x$15._1()).stopProcess());
    }

    private Jumpstart$() {
    }
}

