/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.slieb.throwables.SupplierWithThrowable;

public class SecretKeyGenerator {
    public static InitialStage generate() {
        return new InitialStageImpl();
    }

    private static class BuildFinalImpl
    implements BuildFinal {
        private final SupplierWithThrowable<SecretKey, GeneralSecurityException> supplier;

        BuildFinalImpl(SupplierWithThrowable<SecretKey, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public SecretKey build() throws GeneralSecurityException {
            return (SecretKey)this.supplier.getWithThrowable();
        }
    }

    private static class InitializeStageImpl
    implements InitializeStage {
        private final SupplierWithThrowable<KeyGenerator, GeneralSecurityException> supplier;

        InitializeStageImpl(SupplierWithThrowable<KeyGenerator, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal withRandom(SecureRandom random) {
            return new BuildFinalImpl((SupplierWithThrowable<SecretKey, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                KeyGenerator keyGenerator = (KeyGenerator)this.supplier.getWithThrowable();
                keyGenerator.init(random);
                return keyGenerator.generateKey();
            }));
        }

        @Override
        public BuildFinal withKeySize(int keySize) {
            return new BuildFinalImpl((SupplierWithThrowable<SecretKey, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                KeyGenerator keyGenerator = (KeyGenerator)this.supplier.getWithThrowable();
                keyGenerator.init(keySize);
                return keyGenerator.generateKey();
            }));
        }

        @Override
        public BuildFinal withKeySizeAndRandom(int keySize, SecureRandom random) {
            return new BuildFinalImpl((SupplierWithThrowable<SecretKey, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                KeyGenerator keyGenerator = (KeyGenerator)this.supplier.getWithThrowable();
                keyGenerator.init(keySize, random);
                return keyGenerator.generateKey();
            }));
        }
    }

    private static class InitialStageImpl
    implements InitialStage {
        private InitialStageImpl() {
        }

        @Override
        public InitializeStage withAES() {
            return this.withAlgorithm("AES");
        }

        @Override
        public InitializeStage withHmacSHA1() {
            return this.withAlgorithm("HmacSHA1");
        }

        @Override
        public InitializeStage withHmacSHA224() {
            return this.withAlgorithm("HmacSHA224");
        }

        @Override
        public InitializeStage withHmacSHA256() {
            return this.withAlgorithm("HmacSHA256");
        }

        @Override
        public InitializeStage withHmacSHA384() {
            return this.withAlgorithm("HmacSHA384");
        }

        @Override
        public InitializeStage withHmacSHA512() {
            return this.withAlgorithm("HmacSHA512");
        }

        @Override
        public InitializeStage withAlgorithm(String algorithm) {
            return new InitializeStageImpl((SupplierWithThrowable<KeyGenerator, GeneralSecurityException>)((SupplierWithThrowable)() -> KeyGenerator.getInstance(algorithm)));
        }

        @Override
        public InitializeStage withAlgorithmAndProvider(String algorithm, String provider) {
            return new InitializeStageImpl((SupplierWithThrowable<KeyGenerator, GeneralSecurityException>)((SupplierWithThrowable)() -> KeyGenerator.getInstance(algorithm, provider)));
        }
    }

    public static interface BuildFinal {
        public SecretKey build() throws GeneralSecurityException;
    }

    public static interface InitializeStage {
        public BuildFinal withRandom(SecureRandom var1);

        public BuildFinal withKeySize(int var1);

        public BuildFinal withKeySizeAndRandom(int var1, SecureRandom var2);
    }

    public static interface InitialStage {
        public InitializeStage withAES();

        public InitializeStage withHmacSHA1();

        public InitializeStage withHmacSHA224();

        public InitializeStage withHmacSHA256();

        public InitializeStage withHmacSHA384();

        public InitializeStage withHmacSHA512();

        public InitializeStage withAlgorithm(String var1);

        public InitializeStage withAlgorithmAndProvider(String var1, String var2);
    }
}

