/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class PasswordSpecificKeyStoreBuilder
extends KeyStore.Builder {
    private final Supplier<KeyStore> keyStoreSupplier;
    private final Function<String, KeyStore.ProtectionParameter> passwordFunction;

    protected PasswordSpecificKeyStoreBuilder(Supplier<KeyStore> keyStoreSupplier, Function<String, KeyStore.ProtectionParameter> passwordFunction) {
        Objects.requireNonNull(keyStoreSupplier);
        Objects.requireNonNull(passwordFunction);
        this.keyStoreSupplier = keyStoreSupplier;
        this.passwordFunction = passwordFunction;
    }

    public static KeyStore.Builder newInstance(KeyStore keyStore, Function<String, KeyStore.ProtectionParameter> passwordFunction) {
        Objects.requireNonNull(keyStore);
        Objects.requireNonNull(passwordFunction);
        return PasswordSpecificKeyStoreBuilder.newInstance(() -> keyStore, passwordFunction);
    }

    public static KeyStore.Builder newInstance(Supplier<KeyStore> keyStoreSupplier, Function<String, KeyStore.ProtectionParameter> passwordFunction) {
        Objects.requireNonNull(keyStoreSupplier);
        Objects.requireNonNull(passwordFunction);
        return new PasswordSpecificKeyStoreBuilder(keyStoreSupplier, passwordFunction);
    }

    @Override
    public KeyStore getKeyStore() throws KeyStoreException {
        return this.keyStoreSupplier.get();
    }

    @Override
    public KeyStore.ProtectionParameter getProtectionParameter(String alias) throws KeyStoreException {
        Objects.requireNonNull(alias);
        return this.passwordFunction.apply(alias);
    }
}

