/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.PasswordSpecificKeyStoreBuilder;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class KeyManagerKeyStoreBuilder
extends PasswordSpecificKeyStoreBuilder {
    protected KeyManagerKeyStoreBuilder(Supplier<KeyStore> keyStoreSupplier, Function<String, KeyStore.ProtectionParameter> passwordFunction) {
        super(keyStoreSupplier, passwordFunction);
    }

    public static KeyStore.Builder newInstance(KeyStore keyStore, Function<String, KeyStore.ProtectionParameter> passwordFunction) {
        Objects.requireNonNull(keyStore);
        Objects.requireNonNull(passwordFunction);
        return KeyManagerKeyStoreBuilder.newInstance(() -> keyStore, passwordFunction);
    }

    public static KeyStore.Builder newInstance(Supplier<KeyStore> keyStoreSupplier, Function<String, KeyStore.ProtectionParameter> passwordFunction) {
        Objects.requireNonNull(keyStoreSupplier);
        Objects.requireNonNull(passwordFunction);
        return new KeyManagerKeyStoreBuilder(keyStoreSupplier, passwordFunction);
    }

    public static KeyStore.Builder newInstance(KeyStore keyStore, char[] keyStorePassword) {
        return KeyManagerKeyStoreBuilder.newInstance(keyStore, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(keyStorePassword));
    }

    public static KeyStore.Builder newInstance(KeyStore keyStore, KeyStore.ProtectionParameter protectionParameter) {
        return KeyManagerKeyStoreBuilder.newInstance(keyStore, (String alias) -> protectionParameter);
    }

    @Override
    public KeyStore.ProtectionParameter getProtectionParameter(String alias) throws KeyStoreException {
        int firstDot = alias.indexOf(46);
        int secondDot = alias.indexOf(46, firstDot + 1);
        if (firstDot == -1 || secondDot == firstDot) {
            return super.getProtectionParameter(alias);
        }
        String keyStoreAlias = alias.substring(secondDot + 1);
        return super.getProtectionParameter(keyStoreAlias);
    }
}

