/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

public final class SVMDataGenerator$ {
    public static final SVMDataGenerator$ MODULE$ = new SVMDataGenerator$();

    public void main(String[] args) {
        if (args.length < 2) {
            Predef$.MODULE$.println((Object)"Usage: SVMGenerator <master> <output_dir> [num_examples] [num_features] [num_partitions]");
            System.exit(1);
        }
        String sparkMaster = args[0];
        String outputPath = args[1];
        int nexamples = args.length > 2 ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[2])) : 1000;
        int nfeatures = args.length > 3 ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[3])) : 2;
        int parts = args.length > 4 ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[4])) : 2;
        SparkContext sc = new SparkContext(sparkMaster, "SVMGenerator");
        Random globalRnd = new Random(94720);
        double[] trueWeights = (double[])Array$.MODULE$.fill(nfeatures, (Function0)(JFunction0.mcD.sp & Serializable)() -> globalRnd.nextGaussian(), (ClassTag)ClassTag$.MODULE$.Double());
        RDD data = sc.parallelize((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nexamples), parts, (ClassTag)ClassTag$.MODULE$.Int()).map((Function1 & Serializable)idx -> SVMDataGenerator$.$anonfun$main$2(nfeatures, trueWeights, BoxesRunTime.unboxToInt((Object)idx)), ClassTag$.MODULE$.apply(LabeledPoint.class));
        data.saveAsTextFile(outputPath);
        sc.stop();
    }

    public static final /* synthetic */ LabeledPoint $anonfun$main$2(int nfeatures$1, double[] trueWeights$1, int idx) {
        Random rnd = new Random(42 + idx);
        double[] x = (double[])Array$.MODULE$.fill(nfeatures$1, (Function0)(JFunction0.mcD.sp & Serializable)() -> rnd.nextDouble() * 2.0 - 1.0, (ClassTag)ClassTag$.MODULE$.Double());
        double yD = BLAS$.MODULE$.nativeBLAS().ddot(trueWeights$1.length, x, 1, trueWeights$1, 1);
        double cfr_ignored_0 = rnd.nextGaussian() * 0.1;
        double y = yD < 0.0 ? 0.0 : 1.0;
        return new LabeledPoint(y, Vectors$.MODULE$.dense(x));
    }

    private SVMDataGenerator$() {
    }
}

