/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import breeze.linalg.CSCMatrix;
import java.io.Serializable;
import java.util.Random;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseMatrix$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseMatrix$;
import org.apache.spark.ml.linalg.Vector;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class Matrices$ {
    public static final Matrices$ MODULE$ = new Matrices$();
    private static final DenseMatrix empty = new DenseMatrix(0, 0, Array$.MODULE$.emptyDoubleArray());

    public DenseMatrix empty() {
        return empty;
    }

    public Matrix fromVectors(Seq<Vector> vectors) {
        int nnz;
        long sparseSize;
        int numRows = vectors.length();
        int numCols = ((Vector)vectors.head()).size();
        long denseSize = this.getDenseSize(numCols, numRows);
        if (denseSize < (sparseSize = this.getSparseSize(nnz = BoxesRunTime.unboxToInt((Object)vectors.iterator().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.numNonzeros())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), numRows + 1))) {
            return DenseMatrix$.MODULE$.fromVectors(vectors);
        }
        return SparseMatrix$.MODULE$.fromVectors(vectors);
    }

    public Matrix dense(int numRows, int numCols, double[] values) {
        return new DenseMatrix(numRows, numCols, values);
    }

    public Matrix sparse(int numRows, int numCols, int[] colPtrs, int[] rowIndices, double[] values) {
        return new SparseMatrix(numRows, numCols, colPtrs, rowIndices, values);
    }

    public Matrix fromBreeze(breeze.linalg.Matrix<Object> breeze) {
        breeze.linalg.Matrix<Object> matrix = breeze;
        if (matrix instanceof breeze.linalg.DenseMatrix) {
            breeze.linalg.DenseMatrix denseMatrix = (breeze.linalg.DenseMatrix)matrix;
            return new DenseMatrix(denseMatrix.rows(), denseMatrix.cols(), denseMatrix.data$mcD$sp(), denseMatrix.isTranspose());
        }
        if (matrix instanceof CSCMatrix) {
            CSCMatrix cSCMatrix = (CSCMatrix)matrix;
            return new SparseMatrix(cSCMatrix.rows(), cSCMatrix.cols(), cSCMatrix.colPtrs(), cSCMatrix.rowIndices(), cSCMatrix.data$mcD$sp());
        }
        throw new UnsupportedOperationException("Do not support conversion from type " + breeze.getClass().getName() + ".");
    }

    public Matrix zeros(int numRows, int numCols) {
        return DenseMatrix$.MODULE$.zeros(numRows, numCols);
    }

    public Matrix ones(int numRows, int numCols) {
        return DenseMatrix$.MODULE$.ones(numRows, numCols);
    }

    public Matrix eye(int n) {
        return DenseMatrix$.MODULE$.eye(n);
    }

    public Matrix speye(int n) {
        return SparseMatrix$.MODULE$.speye(n);
    }

    public Matrix rand(int numRows, int numCols, Random rng) {
        return DenseMatrix$.MODULE$.rand(numRows, numCols, rng);
    }

    public Matrix sprand(int numRows, int numCols, double density, Random rng) {
        return SparseMatrix$.MODULE$.sprand(numRows, numCols, density, rng);
    }

    public Matrix randn(int numRows, int numCols, Random rng) {
        return DenseMatrix$.MODULE$.randn(numRows, numCols, rng);
    }

    public Matrix sprandn(int numRows, int numCols, double density, Random rng) {
        return SparseMatrix$.MODULE$.sprandn(numRows, numCols, density, rng);
    }

    public Matrix diag(Vector vector) {
        return DenseMatrix$.MODULE$.diag(vector);
    }

    public Matrix horzcat(Matrix[] matrices) {
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])matrices))) {
            return new DenseMatrix(0, 0, (double[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Double()));
        }
        if (matrices.length == 1) {
            return matrices[0];
        }
        int numRows = matrices[0].numRows();
        BooleanRef hasSparse = BooleanRef.create((boolean)false);
        IntRef numCols = IntRef.create((int)0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])matrices), (Function1 & Serializable)mat -> {
            Matrices$.$anonfun$horzcat$1(numRows, hasSparse, numCols, mat);
            return BoxedUnit.UNIT;
        });
        if (!hasSparse.elem) {
            return new DenseMatrix(numRows, numCols.elem, (double[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])matrices), (Function1 & Serializable)m -> m.toArray(), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double()));
        }
        IntRef startCol = IntRef.create((int)0);
        Tuple3[] entries = (Tuple3[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])matrices), (Function1 & Serializable)mat -> {
            int nCols = mat.numCols();
            Matrix matrix = mat;
            if (matrix instanceof SparseMatrix) {
                SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                Tuple3[] data = new Tuple3[sparseMatrix.values().length];
                IntRef cnt = IntRef.create((int)0);
                sparseMatrix.foreachActive((Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable)(i, j, v) -> {
                    Matrices$.$anonfun$horzcat$6(data, cnt, startCol, BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j), BoxesRunTime.unboxToDouble((Object)v));
                    return BoxedUnit.UNIT;
                });
                startCol$1.elem += nCols;
                return ArraySeq$.MODULE$.unsafeWrapArray((Object)data);
            }
            if (matrix instanceof DenseMatrix) {
                DenseMatrix denseMatrix = (DenseMatrix)matrix;
                ArrayBuffer data = new ArrayBuffer();
                denseMatrix.foreachActive((Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable)(i, j, v) -> {
                    Matrices$.$anonfun$horzcat$7(data, startCol, BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j), BoxesRunTime.unboxToDouble((Object)v));
                    return BoxedUnit.UNIT;
                });
                startCol$1.elem += nCols;
                return data.toSeq();
            }
            throw new MatchError((Object)matrix);
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        return SparseMatrix$.MODULE$.fromCOO(numRows, numCols.elem, (Iterable<Tuple3<Object, Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])entries));
    }

    public Matrix vertcat(Matrix[] matrices) {
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])matrices))) {
            return new DenseMatrix(0, 0, (double[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Double()));
        }
        if (matrices.length == 1) {
            return matrices[0];
        }
        int numCols = matrices[0].numCols();
        BooleanRef hasSparse = BooleanRef.create((boolean)false);
        IntRef numRows = IntRef.create((int)0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])matrices), (Function1 & Serializable)mat -> {
            Matrices$.$anonfun$vertcat$1(numCols, hasSparse, numRows, mat);
            return BoxedUnit.UNIT;
        });
        if (!hasSparse.elem) {
            double[] allValues = new double[numRows.elem * numCols];
            IntRef startRow = IntRef.create((int)0);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])matrices), (Function1 & Serializable)mat -> {
                Matrices$.$anonfun$vertcat$3(numRows, startRow, allValues, mat);
                return BoxedUnit.UNIT;
            });
            return new DenseMatrix(numRows.elem, numCols, allValues);
        }
        IntRef startRow = IntRef.create((int)0);
        Tuple3[] entries = (Tuple3[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])matrices), (Function1 & Serializable)mat -> {
            int nRows = mat.numRows();
            Matrix matrix = mat;
            if (matrix instanceof SparseMatrix) {
                SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                Tuple3[] data = new Tuple3[sparseMatrix.values().length];
                IntRef cnt = IntRef.create((int)0);
                sparseMatrix.foreachActive((Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable)(i, j, v) -> {
                    Matrices$.$anonfun$vertcat$6(data, cnt, startRow, BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j), BoxesRunTime.unboxToDouble((Object)v));
                    return BoxedUnit.UNIT;
                });
                startRow$2.elem += nRows;
                return ArraySeq$.MODULE$.unsafeWrapArray((Object)data);
            }
            if (matrix instanceof DenseMatrix) {
                DenseMatrix denseMatrix = (DenseMatrix)matrix;
                ArrayBuffer data = new ArrayBuffer();
                denseMatrix.foreachActive((Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable)(i, j, v) -> {
                    Matrices$.$anonfun$vertcat$7(data, startRow, BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j), BoxesRunTime.unboxToDouble((Object)v));
                    return BoxedUnit.UNIT;
                });
                startRow$2.elem += nRows;
                return data.toSeq();
            }
            throw new MatchError((Object)matrix);
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        return SparseMatrix$.MODULE$.fromCOO(numRows.elem, numCols, (Iterable<Tuple3<Object, Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])entries));
    }

    public long getSparseSize(long numActives, long numPtrs) {
        int doubleBytes = 8;
        int intBytes = 4;
        long arrayHeader = 12L;
        return (long)doubleBytes * numActives + (long)intBytes * numActives + (long)intBytes * numPtrs + arrayHeader * 3L + 9L;
    }

    public long getDenseSize(long numCols, long numRows) {
        int doubleBytes = 8;
        long arrayHeader = 12L;
        return (long)doubleBytes * numCols * numRows + arrayHeader + 9L;
    }

    public static final /* synthetic */ void $anonfun$horzcat$1(int numRows$7, BooleanRef hasSparse$1, IntRef numCols$7, Matrix mat) {
        Predef$.MODULE$.require(numRows$7 == mat.numRows(), (Function0 & Serializable)() -> "The number of rows of the matrices in this sequence, don't match!");
        Matrix matrix = mat;
        if (matrix instanceof SparseMatrix) {
            hasSparse$1.elem = true;
        } else if (matrix instanceof DenseMatrix) {
        } else {
            throw new IllegalArgumentException("Unsupported matrix format. Expected SparseMatrix or DenseMatrix. Instead got: " + mat.getClass());
        }
        numCols$7.elem += mat.numCols();
    }

    public static final /* synthetic */ void $anonfun$horzcat$6(Tuple3[] data$1, IntRef cnt$1, IntRef startCol$1, int i, int j, double v) {
        data$1[cnt$1.elem] = new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)(j + startCol$1.elem)), (Object)BoxesRunTime.boxToDouble((double)v));
        ++cnt$1.elem;
    }

    public static final /* synthetic */ void $anonfun$horzcat$7(ArrayBuffer data$2, IntRef startCol$1, int i, int j, double v) {
        if (v != 0.0) {
            data$2.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)(j + startCol$1.elem)), (Object)BoxesRunTime.boxToDouble((double)v)));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$vertcat$1(int numCols$8, BooleanRef hasSparse$2, IntRef numRows$8, Matrix mat) {
        Predef$.MODULE$.require(numCols$8 == mat.numCols(), (Function0 & Serializable)() -> "The number of columns of the matrices in this sequence, don't match!");
        Matrix matrix = mat;
        if (matrix instanceof SparseMatrix) {
            hasSparse$2.elem = true;
        } else if (matrix instanceof DenseMatrix) {
        } else {
            throw new IllegalArgumentException("Unsupported matrix format. Expected SparseMatrix or DenseMatrix. Instead got: " + mat.getClass());
        }
        numRows$8.elem += mat.numRows();
    }

    public static final /* synthetic */ void $anonfun$vertcat$4(IntRef numRows$8, IntRef startRow$1, double[] allValues$1, int i, int j, double v) {
        int indStart = j * numRows$8.elem + startRow$1.elem;
        allValues$1[indStart + i] = v;
    }

    public static final /* synthetic */ void $anonfun$vertcat$3(IntRef numRows$8, IntRef startRow$1, double[] allValues$1, Matrix mat) {
        int nRows = mat.numRows();
        mat.foreachActive((Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable)(i, j, v) -> {
            Matrices$.$anonfun$vertcat$4(numRows$8, startRow$1, allValues$1, BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j), BoxesRunTime.unboxToDouble((Object)v));
            return BoxedUnit.UNIT;
        });
        startRow$1.elem += nRows;
    }

    public static final /* synthetic */ void $anonfun$vertcat$6(Tuple3[] data$3, IntRef cnt$2, IntRef startRow$2, int i, int j, double v) {
        data$3[cnt$2.elem] = new Tuple3((Object)BoxesRunTime.boxToInteger((int)(i + startRow$2.elem)), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)v));
        ++cnt$2.elem;
    }

    public static final /* synthetic */ void $anonfun$vertcat$7(ArrayBuffer data$4, IntRef startRow$2, int i, int j, double v) {
        if (v != 0.0) {
            data$4.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)(i + startRow$2.elem)), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)v)));
            return;
        }
    }

    private Matrices$() {
    }
}

