/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringRepeat$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, n) - Returns the string which repeats the given string value n times.", examples="\n    Examples:\n      > SELECT _FUNC_('123', 2);\n       123123\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005eh\u0001\u0002\u0011\"\u0001:B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005P\u0001\tE\t\u0015!\u0003K\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015Q\u0006\u0001\"\u0011J\u0011\u0015Y\u0006\u0001\"\u0011J\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015)\b\u0001\"\u0011w\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!9\u0011Q\u0004\u0001\u0005R\u0005}\u0001\"CA\u0015\u0001\u0005\u0005I\u0011AA\u0016\u0011%\t\t\u0004AI\u0001\n\u0003\t\u0019\u0004C\u0005\u0002J\u0001\t\n\u0011\"\u0001\u00024!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0013Q\n\u0005\n\u0003;\u0002\u0011\u0011!C\u0001\u0003?B\u0011\"a\u001a\u0001\u0003\u0003%\t!!\u001b\t\u0013\u0005=\u0004!!A\u0005B\u0005E\u0004\"CA@\u0001\u0005\u0005I\u0011AAA\u0011%\t)\tAA\u0001\n\u0003\n9\tC\u0005\u0002\f\u0002\t\t\u0011\"\u0011\u0002\u000e\u001eI\u0011\u0011W\u0011\u0002\u0002#\u0005\u00111\u0017\u0004\tA\u0005\n\t\u0011#\u0001\u00026\"1\u0001K\u0007C\u0001\u0003\u001bD\u0011\"a4\u001b\u0003\u0003%)%!5\t\u0013\u0005M'$!A\u0005\u0002\u0006U\u0007\"CAn5\u0005\u0005I\u0011QAo\u0011%\tyOGA\u0001\n\u0013\t\tP\u0001\u0007TiJLgn\u001a*fa\u0016\fGO\u0003\u0002#G\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t!S%\u0001\u0005dCR\fG._:u\u0015\t1s%A\u0002tc2T!\u0001K\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Z\u0013AB1qC\u000eDWMC\u0001-\u0003\ry'oZ\u0002\u0001'\u0015\u0001qf\r\u001c=!\t\u0001\u0014'D\u0001\"\u0013\t\u0011\u0014E\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0001\u0007N\u0005\u0003k\u0005\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\b!J|G-^2u!\tiTI\u0004\u0002?\u0007:\u0011qHQ\u0007\u0002\u0001*\u0011\u0011)L\u0001\u0007yI|w\u000e\u001e \n\u0003eJ!\u0001\u0012\u001d\u0002\u000fA\f7m[1hK&\u0011ai\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\tb\n1a\u001d;s+\u0005Q\u0005C\u0001\u0019L\u0013\ta\u0015E\u0001\u0006FqB\u0014Xm]:j_:\fAa\u001d;sA\u0005)A/[7fg\u00061A/[7fg\u0002\na\u0001P5oSRtDc\u0001*T)B\u0011\u0001\u0007\u0001\u0005\u0006\u0011\u0016\u0001\rA\u0013\u0005\u0006\u001d\u0016\u0001\rAS\u0001\u000f]VdG.\u00138u_2,'/\u00198u+\u00059\u0006CA\u001cY\u0013\tI\u0006HA\u0004C_>dW-\u00198\u0002\t1,g\r^\u0001\u0006e&<\u0007\u000e^\u0001\tI\u0006$\u0018\rV=qKV\ta\f\u0005\u0002`E6\t\u0001M\u0003\u0002bK\u0005)A/\u001f9fg&\u00111\r\u0019\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003\u0019\u00042!P4j\u0013\tAwIA\u0002TKF\u0004\"a\u00186\n\u0005-\u0004'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u00031qW\u000f\u001c7TC\u001a,WI^1m)\rq\u0017o\u001d\t\u0003o=L!\u0001\u001d\u001d\u0003\u0007\u0005s\u0017\u0010C\u0003s\u0017\u0001\u0007a.\u0001\u0004tiJLgn\u001a\u0005\u0006i.\u0001\rA\\\u0001\u0002]\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003]\u0004\"\u0001\u001f?\u000f\u0005eT\bCA 9\u0013\tY\b(\u0001\u0004Qe\u0016$WMZ\u0005\u0003{z\u0014aa\u0015;sS:<'BA>9\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\u0004\u0005=\u0011\u0011\u0004\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011B\u0011\u0002\u000f\r|G-Z4f]&!\u0011QBA\u0004\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\t\u001b\u0001\u0007\u00111C\u0001\u0004GRD\b\u0003BA\u0003\u0003+IA!a\u0006\u0002\b\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA\u000e\u001b\u0001\u0007\u00111A\u0001\u0003KZ\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000bI\u000b\t#!\n\t\r\u0005\rb\u00021\u0001K\u0003\u001dqWm\u001e'fMRDa!a\n\u000f\u0001\u0004Q\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0006%\u00065\u0012q\u0006\u0005\b\u0011>\u0001\n\u00111\u0001K\u0011\u001dqu\u0002%AA\u0002)\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00026)\u001a!*a\u000e,\u0005\u0005e\u0002\u0003BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u00119\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000f\niDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001f\u0002B!!\u0015\u0002\\5\u0011\u00111\u000b\u0006\u0005\u0003+\n9&\u0001\u0003mC:<'BAA-\u0003\u0011Q\u0017M^1\n\u0007u\f\u0019&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002bA\u0019q'a\u0019\n\u0007\u0005\u0015\u0004HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002o\u0003WB\u0011\"!\u001c\u0015\u0003\u0003\u0005\r!!\u0019\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\bE\u0003\u0002v\u0005md.\u0004\u0002\u0002x)\u0019\u0011\u0011\u0010\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002~\u0005]$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2aVAB\u0011!\tiGFA\u0001\u0002\u0004q\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0014\u0002\n\"I\u0011QN\f\u0002\u0002\u0003\u0007\u0011\u0011M\u0001\u0007KF,\u0018\r\\:\u0015\u0007]\u000by\t\u0003\u0005\u0002na\t\t\u00111\u0001oQM\u0001\u00111SAM\u00037\u000by*!)\u0002&\u0006\u001d\u00161VAW!\r\u0001\u0014QS\u0005\u0004\u0003/\u000b#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003;\u000b\u0011k\u0018$V\u001d\u000e{\u0006f\u001d;sY\u0001r\u0017\u0006I\u0017!%\u0016$XO\u001d8tAQDW\rI:ue&tw\rI<iS\u000eD\u0007E]3qK\u0006$8\u000f\t;iK\u0002:\u0017N^3oAM$(/\u001b8hAY\fG.^3!]\u0002\"\u0018.\\3t]\u0005AQ\r_1na2,7/\t\u0002\u0002$\u0006\u0001%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00142eM:C\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\n$gM\u00193g)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002*\u0006)\u0011GL\u001b/a\u0005)qM]8va\u0006\u0012\u0011qV\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\r'R\u0014\u0018N\\4SKB,\u0017\r\u001e\t\u0003ai\u0019RAGA\\\u0003\u0007\u0004r!!/\u0002@*S%+\u0004\u0002\u0002<*\u0019\u0011Q\u0018\u001d\u0002\u000fI,h\u000e^5nK&!\u0011\u0011YA^\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003\u000b\fY-\u0004\u0002\u0002H*!\u0011\u0011ZA,\u0003\tIw.C\u0002G\u0003\u000f$\"!a-\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0014\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bI\u000b9.!7\t\u000b!k\u0002\u0019\u0001&\t\u000b9k\u0002\u0019\u0001&\u0002\u000fUt\u0017\r\u001d9msR!\u0011q\\Av!\u00159\u0014\u0011]As\u0013\r\t\u0019\u000f\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b]\n9O\u0013&\n\u0007\u0005%\bH\u0001\u0004UkBdWM\r\u0005\t\u0003[t\u0012\u0011!a\u0001%\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005M\b\u0003BA)\u0003kLA!a>\u0002T\t1qJ\u00196fGR\u0004")
public class StringRepeat
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression str;
    private final Expression times;

    public static Option<Tuple2<Expression, Expression>> unapply(StringRepeat x$0) {
        return StringRepeat$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, StringRepeat> tupled() {
        return StringRepeat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, StringRepeat>> curried() {
        return StringRepeat$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression times() {
        return this.times;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression left() {
        return this.str();
    }

    @Override
    public Expression right() {
        return this.times();
    }

    @Override
    public DataType dataType() {
        return this.str().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public Object nullSafeEval(Object string, Object n) {
        return ((UTF8String)string).repeat(Predef$.MODULE$.Integer2int((Integer)n));
    }

    @Override
    public String prettyName() {
        return "repeat";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(l, r) -> "(" + l + ").repeat(" + r + ")");
    }

    @Override
    public StringRepeat withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public StringRepeat copy(Expression str, Expression times) {
        return new StringRepeat(str, times);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.times();
    }

    @Override
    public String productPrefix() {
        return "StringRepeat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.times();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringRepeat;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "str";
            }
            case 1: {
                return "times";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringRepeat)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringRepeat stringRepeat = (StringRepeat)x$1;
        Expression expression = this.str();
        Expression expression2 = stringRepeat.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.times();
        Expression expression4 = stringRepeat.times();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringRepeat.canEqual(this)) return false;
        return true;
    }

    public StringRepeat(Expression str, Expression times) {
        this.str = str;
        this.times = times;
        ExpectsInputTypes.$init$(this);
    }
}

