<!-- markdownlint-disable  MD013 -->

<!-- wiki-title Example commands for acme clients -->

# acme.sh

## register account

```bash
acme.sh --server http://<server address> --register-account --accountemail <email address> --debug 2 --output-insecure
```

## deactivate account

```bash
acme.sh --server http://<server address> --deactivate-account --debug 2 --output-insecure
```

## cert enrollment

```bash
acme.sh --server http://<server address>  --issue -d acme-1.example.com -d acme-2.example.com --standalone --debug 2 --output-insecure --force
```

## cert revocation

```bash
acme.sh --server http://<server address> --revoke -d acme-1.example.com -d acme-2.example.com --debug 2 --output-insecure
```

# Certbot

## account registration

```bash
certbot register --agree-tos -m <email address>  --server http://<server address> --no-eff-email
```

## account deletion

```bash
rm -rf /etc/letsencrypt/accounts/*
```

## certificate enrollment

```bash
certbot certonly --server http://<server address> --standalone --preferred-challenges http -d certbot-1.example.com -d certbot-2.example.com --cert-name certbot-test
```

## certificate revocation

```bash
certbot revoke --server http://<server address> --cert-name certbot-test
```

IMPORTANT: by default a CSR generated by certbot does not contain any subject name. Such CSR will be refused by enterprise CA servers. For mitigation you need to create a CA policy setting a subject name.
[Example CA policy for Insta Certifier](certifier.md)

# lego

## account registration and cert enrollment

```bash
lego -s http://<server address> -a --email <email address> -d lego-1.bar.local -d lego-2.bar.local --http run
```

## revoke a certificate

```bash
lego -s http://<server address> -a --email <email address> -d lego-1.bar.local revoke
```

# acmeshell

## start the shell

```bash
acmeshell -directory http://<server address> -postAsGet=true
```

## create a new account

```bash
> newAccount -contacts=grindsa@foo.bar,
```

## create a new order

```bash
> newOrder -identifiers=foo.bar
```

## get status of the order

```bash
> getOrder -order 0
```

## get authorization details for order

```bash
> getAuthz -order=0 -identifier=foo.bar
```

## get http challenges

```bash
> getChall -order=0 -identifier=foo.bar -type=http-01
```

## solve http challenge of order's auth

```bash
> solve -order=0 -identifier=foo.bar -challengeType=http-01
```

## poll orderstatus (still pending)

```bash
> poll -order=0
```

## finalize order

```bash
> finalize -order=0
```

## poll order to check status

```bash
> poll -order=0 -status=valid
```

## get certificate

```bash
> getCert -order=0
```
